/* 
 * File:   gpsserial.h
 * Author: User
 *
 * Created on 19 October 2015, 11:13 AM
 */

#ifndef GPSSERIAL_H
#define	GPSSERIAL_H

#include "Timezone/tzmaths.h"


#ifdef	__cplusplus
extern "C" {
#endif

typedef struct {
    unsigned char inverted;
    unsigned short baud_rate;
} serial_state;

__attribute__((mips16)) void setup_serial(unsigned char invert, unsigned int baud_rate);
__attribute__((mips16)) void close_serial();
__attribute__((mips16)) int serial_read(int max_read, const signed long* tzinfo, const daylight_savings_info* dstinfo);
__attribute__((mips16)) void save_serial_state_and_close(serial_state* pState);
__attribute__((mips16)) void restore_serial_state(const serial_state* pState);
__attribute__((mips16)) void decimal_time_date_to_bcd(rtccTime* timehere, rtccDate* datehere, int dectime, int decdate);
__attribute__((mips16)) void bcd_time_date_to_decimal(int* timehere, int* datehere, const rtccTime* bcdtime, const rtccDate* bcddate);
__attribute__((mips16)) void RtccFixupDOW(rtccDate* date);
__attribute__((mips16)) void time_date_add_one_second(rtccTime* time, rtccDate* date);
__attribute__((mips16)) unsigned char times_are_one_second_apart(const rtccTime* time1, const rtccDate* date1, const rtccTime* time2, const rtccDate* date2);

extern int gps_fix, gps_numsats, gps_time, gps_fractime, gps_date, gps_lat, gps_lon, gps_detected, gps_fixgood, gps_datetimelatlongood, gps_fixgoodfor, gps_good_counter;
extern int tz_searching, timezone_found, tz_override, new_tz_override, cycles_without_serial_rx;
extern unsigned long serial_rx_bytes_since_last_valid;

#ifdef	__cplusplus
}
#endif

#endif	/* GPSSERIAL_H */

